/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.iw;

import com.ibm.hsc.common.util.AusMicrocodeLog;
import com.ibm.hsc.common.util.HSCPanelBean;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.iw.WizardConstants;
import com.ibm.hsc.iw.WizardFrameTask;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.UserTaskManager;
import java.util.GregorianCalendar;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class WizardFrameBean
extends HSCPanelBean
implements WizardConstants {
    private static final String TRACE_MASKD = "JIWZWFBD";
    private static final String TRACE_MASKF = "JIWZWFBF";
    private static final String TRACE_MASKT = "JIWZWFBT";
    private static WizardFrameBean currentFrameBean = null;
    private boolean enableBackButton;
    private boolean enableNextButton;
    private boolean enableFinishButton;
    private boolean useCloseButtonInsteadOfCancel;
    private boolean confirmExit;
    private LocalizableText titleExt;

    public WizardFrameBean(LocalizableText localizableText, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.enableBackButton = bl;
        this.enableNextButton = bl2;
        this.enableFinishButton = bl3;
        this.useCloseButtonInsteadOfCancel = bl4;
        this.confirmExit = bl5;
        this.titleExt = localizableText;
        this.setBeanName("WizardFrame");
    }

    public static void main(String[] stringArray) {
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void load() {
        currentFrameBean = this;
    }

    public void save() {
    }

    public void prepare() {
        UserTaskManager userTaskManager = null;
        String string = null;
        String string2 = null;
        if (Trace.LEVEL >= 2) {
            Trace.trace(TRACE_MASKF, "-> prepare()");
        }
        if ((userTaskManager = this.getUserTaskManager()) != null) {
            if (!this.enableBackButton) {
                userTaskManager.setEnabled("BackButton", false);
            }
            if (!this.enableNextButton) {
                userTaskManager.setEnabled("NextButton", false);
            }
            if (!this.enableFinishButton) {
                userTaskManager.setEnabled("FinishButton", false);
            }
            if (this.useCloseButtonInsteadOfCancel) {
                try {
                    string2 = ResourceBundle.getBundle("com.ibm.hsc.common.bundles.GuidedSetupWizardText").getString("CLOSE");
                }
                catch (MissingResourceException missingResourceException) {
                    string2 = "Close";
                }
                userTaskManager.setCaptionText("CancelButton", string2);
                if (Trace.LEVEL >= 3) {
                    Trace.trace(TRACE_MASKD, "cancel button set with a caption of " + string2);
                }
            }
            string = new LocalizableText("com.ibm.hsc.common.bundles.GuidedSetupWizardText", "WIZARD_NAME", null).toString();
            if (this.titleExt != null) {
                string = string + " - " + this.titleExt.toString();
            }
            userTaskManager.setCaptionText("WizardFrame", string);
        } else {
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "Can not get the UTM.");
            }
            new AusMicrocodeLog(LOG_INFO, 10).writeEntryFromTaskletClient();
        }
        if (Trace.LEVEL >= 2) {
            Trace.trace(TRACE_MASKF, "<- prepare()");
        }
    }

    public void panelAction(TaskActionEvent taskActionEvent) {
        String string = null;
        String string2 = null;
        UserTaskManager userTaskManager = null;
        PanelTaskletRequest panelTaskletRequest = null;
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "->panelAction() : \n\tBean Name     : " + this.getBeanName() + "\n\tCurrentElement: " + taskActionEvent.getCurrentElement() + "\n\tElementName   : " + taskActionEvent.getElementName() + "\n\tActionCommand : " + taskActionEvent.getActionCommand());
        }
        string = taskActionEvent.getElementName();
        string2 = taskActionEvent.getActionCommand();
        userTaskManager = this.getUserTaskManager();
        if (string2.equals("BackButton")) {
            this.postParentalAction(taskActionEvent, this);
        } else if (string2.equals("NextButton")) {
            this.postParentalAction(taskActionEvent, this);
        } else if (string2.equals("FinishButton")) {
            PanelTaskletRequest panelTaskletRequest2 = null;
            panelTaskletRequest2 = new PanelTaskletRequest((Object)(this.getUniqueBeanName() + '.' + taskActionEvent.getActionCommand()));
            panelTaskletRequest2.setData("Source", (Object)this.getUniqueBeanName());
            panelTaskletRequest2.setData("Action", (Object)taskActionEvent.getActionCommand());
            panelTaskletRequest2.setData("Data", null);
            WizardFrameBean.postAndWaitForResponse(this, panelTaskletRequest2);
        } else if (string2.equals("CancelButton") || string2.equals("CANCEL")) {
            panelTaskletRequest = new PanelTaskletRequest((Object)(this.getBeanName() + '.' + string2));
            panelTaskletRequest.setData("Action", (Object)string2);
            panelTaskletRequest.setData("Source", (Object)this.getBeanName());
            panelTaskletRequest.setData("Data", (Object)new Boolean(this.confirmExit));
            WizardFrameBean.postAndWaitForResponse(this, panelTaskletRequest);
            if (string2.equals("CANCEL") && this.confirmExit) {
                throw new IllegalUserDataException();
            }
        } else {
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "Unknown event received in panelAction(...).");
            }
            new AusMicrocodeLog(LOG_INFO, 7).writeEntryFromTaskletClient();
        }
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<-panelAction(...)");
        }
    }

    private void postRequest(TaskActionEvent taskActionEvent) {
        PanelTaskletRequest panelTaskletRequest = null;
        panelTaskletRequest = new PanelTaskletRequest((Object)(this.getUniqueBeanName() + '.' + taskActionEvent.getActionCommand()));
        panelTaskletRequest.setData("Source", (Object)this.getUniqueBeanName());
        panelTaskletRequest.setData("Action", (Object)taskActionEvent.getActionCommand());
        panelTaskletRequest.setData("Data", null);
        this.postTaskletRequest(panelTaskletRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void postAndWaitForResponse(PanelBean panelBean, PanelTaskletRequest panelTaskletRequest) {
        Object object = WizardFrameTask.synchronizer;
        synchronized (object) {
            panelBean.postTaskletRequest(panelTaskletRequest);
            if (Trace.LEVEL >= 2) {
                Trace.trace(TRACE_MASKF, "waiting for response");
            }
            long l = new GregorianCalendar().getTimeInMillis() + 30000L;
            while (true) {
                long l2;
                if ((l2 = new GregorianCalendar().getTimeInMillis()) >= l) {
                    continue;
                }
                try {
                    WizardFrameTask.synchronizer.wait(l - l2);
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "done waiting for a response");
        }
    }

    void enableNextButton(boolean bl) {
        UserTaskManager userTaskManager = null;
        userTaskManager = this.getUserTaskManager();
        if (userTaskManager != null) {
            userTaskManager.setEnabled("NextButton", bl);
        } else {
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "Can not get the UTM.");
            }
            new AusMicrocodeLog(LOG_INFO, 10).writeEntryFromTaskletClient();
        }
    }

    static WizardFrameBean getInstance() {
        return currentFrameBean;
    }
}

